/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.modifier.iceandfire;

import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import com.xiaoyue.tinkers_ingenuity.generic.XIModifier;
import com.xiaoyue.tinkers_ingenuity.register.Modifiers;
import com.xiaoyue.tinkers_ingenuity.utils.ArmorLevelUtils;
import com.xiaoyue.tinkers_ingenuity.utils.XModifierUtils;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.ModList;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class DragonSteel
extends XIModifier {
    boolean enabled = ModList.get().isLoaded("iceandfire");

    public void addToolStats(ToolRebuildContext context, int level, ModifierStatsBuilder builder) {
        ToolStats.ARMOR.add(builder, 4.0);
        ToolStats.ARMOR_TOUGHNESS.add(builder, 9.0);
    }

    @Override
    public void onModifierHurt(LivingHurtEvent event, LivingEntity entity, LivingEntity attacker) {
        int armorLevel;
        Player player;
        if (XModifierUtils.getAllSlotLevel(entity, this) > 0 && this.enabled && entity instanceof Player) {
            player = (Player)entity;
            if ((attacker instanceof EntityIceDragon || attacker instanceof EntityFireDragon || attacker instanceof EntityLightningDragon) && (armorLevel = ArmorLevelUtils.getSingleArmorLevel((LivingEntity)player, Modifiers.DRAGON_STEEL.getId())) > 0) {
                event.setAmount(event.getAmount() * 0.83f);
            }
        }
        if (XModifierUtils.getAllSlotLevel(attacker, this) > 0 && this.enabled && attacker instanceof Player && (armorLevel = ArmorLevelUtils.getSingleArmorLevel((LivingEntity)(player = (Player)attacker), Modifiers.DRAGON_STEEL.getId())) > 0 && player.m_6844_(EquipmentSlot.MAINHAND).m_41619_() && player.m_6844_(EquipmentSlot.OFFHAND).m_41619_()) {
            event.setAmount(event.getAmount() + 0.75f * (float)armorLevel);
        }
    }
}

